--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------
-- Miguel Fichier Revision M19
------------------------------------------------------------------------------------------------------- 
-- Miguel21 modification M19 : Repair SAM

--List of Return functions to build conditions:
--Return.Time()							returns time of day in seconds
--Return.Day()							returns day of month
--Return.Month()						returns month as number
--Return.Year()							returns year as number
--Return.Mission()						returns campaign mission number
--Return.CampFlag(flag-n)				returns value of campaign flag
--Return.AirUnitActive("UnitName")		returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")		returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")		returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")		returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")		returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")		returns percentage of alive sub elements in target
--Return.GroupHidden("GroupName")		returns group hidden status
--Return.GroupProbability("GroupName")	returns group spawn probability value between 0 and 1

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.SetCampFlag(flag-n, boolean/number)
--Action.AddCampFlag(flag-n, number)
--Action.AddImage("filename.jpg", "blue") -- "blue" "red" "all"
--Action.CampaignEnd("win"/"draw"/"loss")
--Action.TargetActive("TargetName", boolean)
--Action.AirUnitActive("UnitName", boolean)
--Action.AirUnitBase("UnitName", "BaseName")
--Action.AirUnitPlayer("UnitName", boolean)
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)
--Action.AirUnitRepair()
--Action.GroundUnitRepair()
--Action.AddGroundTargetIntel("sideName")
--Action.GroupHidden("GroupName", boolean)
--Action.GroupProbability("GroupName", number 0-1)

--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			[1] = 'Action.Text("Operation Fortitude South")',
			[2] = 'Action.Text("We have to divert the Germans attention from the Normandy and make them believe that the invasion would happen accross the Straits of Dover.  This would also give use the opportunity to destroy their coastal guns and V-1 launch sites.  After re-taking DunkirkThe Russians even sent I-16s from their Norwegian front to make the deception more believable.")',
			[3] = 'Action.Text("Eventhough our ships in the Straits are nothing more than unmanned hulls.  We must not let them be destroyed.  Losing the ships would mean that we could not mount an invasion.  The Germans would then shift their forces to Normandy.  Jeopardizing the landings.")',
			[4] = 'Action.Text("Intel is limited and at times inaccurate.  Be ready for nasty surprises.  The only recon photos we have are of fixed isntallations and some Divisions who have been stationed near towns for some time.  Go find the enemey and destroy them.")',
			[5] = 'Action.AddImage("The Channel.png", "all")',
			-- [4] = 'Action.Text("The Bullseye Coordinates are N 42 11 50 97 - E 41 38 31 12.")',
		},
	},
	
----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 100',
		action = {
			[1] = 'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 80',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
	},
	["Campaign 40 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 60',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
	},
	["Campaign 50 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 50',
		action = {
			[1] = 'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
		},
	},

	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = false,
		condition = 'GroundTarget["blue"].percent < 30',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("The ground forces of The Third Reich have a decimated.  Remaining German troops are on the retreat.  We are on our way to Berlin!")',
			[3] = 'Action.AddImage("Victory.jpg", "all")',
			[4] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 2"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitReady("Jagdgeschwader 22") + Return.AirUnitReady("Jagdgeschwader 9") + Return.AirUnitReady("Jagdgeschwader 8") + Return.AirUnitReady("Jagdgeschwader 338") + Return.AirUnitReady("Jagdgeschwader 339") + Return.AirUnitReady("V./Kampfgeschwader 38") + Return.AirUnitReady("R/BF109") + Return.AirUnitReady("R/Anton") + Return.AirUnitReady("R/DORA") + Return.AirUnitReady("R/Junkers") < 1',
			action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("You have defeated the Luftwaffe.  Ground forces can now advance without any threat from the skies.  You have gained air superiority.")',
			[3] = 'Action.AddImage("Victory.jpg", "all")',
			[4] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = false,
		condition = 'Return.AirUnitAlive("368 Fighter Group") + Return.AirUnitReady("R/P-47-30") < 4',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("You have taken too many loses.  We would no longer be able to achieve air superiority")',
			[3] = 'Action.AddImage("Dover Bombed.jpg", "all")',
			[4] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss 2"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Invation Fleet") == 0 and Return.TargetAlive("Invation Fleet 2") == 0 and Return.TargetAlive("Invation Fleet 3") == 0',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("We have lost our fleet.  The Germans now think that we are no longer a threat.  They would move their forces to Normandy and hamper the invasion plans.")',
			[3] = 'Action.AddImage("Dover Bombed.jpg", "all")',
			[4] = 'NoMoreNewspaper = true',
		},
	},	
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 40',
		action = {
			[1] = 'Action.CampaignEnd("draw")',
			[2] = 'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Russian Air Force and infrastructure, US Central Command has called off all squadrons from offensive operations. We hope negociations with Russians will convince them to withdraw from Georgia")',
			[3] = 'NoMoreNewspaper = true',
		},
	},

	----- CONVOY MOVEMENT -----
	["U-479"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("U-479", {{"S1-1", "S1-2", "S1-3"}}, 15, 15, nil)',
	},
	["U-571"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("U-571", {{"S2-1", "S2-2", "S2-3"}}, 15, 15, nil)',
	},
	["U-168"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("U-168", {{"S3-1", "S3-2", "S3-3"}}, 15, 15, nil)',
	},
	["U-281"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("U-281", {{"S4-1", "S4-2", "S4-3"}}, 15, 15, nil)',
	},
	["U-91"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("U-91", {{"S5-1", "S5-2", "S5-3"}}, 15, 15, nil)',
	},

	----- UNIT DESACTIVATION -----
--[[	["Unit Desactivate B-52H and B-1B"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() >= 10',
		action = {
			-- [1] = 'Action.AirUnitActive("96 BW", false)',
			[1] = 'Action.AirUnitActive("69 BS", false)',
			[2] = 'Action.Text("After intensive flights against Russians SAM sites, B-52H from 96 BS and B-1B from 69 BS have reduced significantly SAM sites effectiveness. They have to stop their missions but it should be easier for TF-74 to attack strategics targets in Georgia")',
			-- [4] = 'Action.AddImage("Newspaper_Phantom.jpg")',
		},
	},	--]]

	----- AIRBASE STRIKES -----
	["Dunkirk Mardyck Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Dunkirk Mardyck Airbase Supplies") < 1',
		action = {
			[1] = 'db_airbases["Dunkirk Mardyck"].inactive = true',
		}
	},
	["Dunkirk Mardyck Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Dunkirk Mardyck Airbase Supplies") < 1',
		action = {
			[1] = 'Action.Text("After the facilities at Dunkirk Mardyck Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},
	["Hawkinge Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Hawkinge Airbase Supplies") < 1',
		action = {
			[1] = 'db_airbases["Hawkinge"].inactive = true',
		}
	},
	["Hawkinge Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Hawkinge Airbase Supplies") < 1',
		action = {
			[1] = 'Action.Text("After the facilities at Hawkinge Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},
	["Lympne Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Lympne Airbase Supplies") < 1',
		action = {
			[1] = 'db_airbases["Lympne"].inactive = true',
		}
	},
	["Lympne Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Lympne Airbase Supplies") < 1',
		action = {
			[1] = 'Action.Text("After the facilities at Lympne Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},
	["Manston Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Manston Airbase Supplies") < 1',
		action = {
			[1] = 'db_airbases["Manston"].inactive = true',
		}
	},
	["Manston Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Manston Airbase Supplies") < 1',
		action = {
			[1] = 'Action.Text("After the facilities at Manston Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},	
	["Saint Omer Longuenesse Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Saint Omer Longuenesse Airbase Supplies") < 1',
		action = {
			[1] = 'db_airbases["Saint Omer Longuenesse"].inactive = true',
		}
	},
	["Saint Omer Longuenesse Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Saint Omer Longuenesse Airbase Supplies") < 1',
		action = {
			[1] = 'Action.Text("The infrastructure at Merville Calonne Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume.")',
		}
	},
	["Merville Calonne Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Merville Calonne Airbase Supplies") < 1',
		action = {
			[1] = 'db_airbases["Merville Calonne"].inactive = true',
		}
	},
	["Merville Calonne Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Merville Calonne Airbase Supplies") < 1',
		action = {
			[1] = 'Action.Text("The infrastructure at Merville Calonne Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume.")',
		}
	},	
	["Abbeville Drucat Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Abbeville Drucat Airbase Supplies") < 1',
		action = {
			[1] = 'db_airbases["Abbeville Drucat"].inactive = true',
		}
	},
	["Abbeville Drucat Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Abbeville Drucat Airbase Supplies") < 1',
		action = {
			[1] = 'Action.Text("The infrastructure at Merville Calonne Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume.")',
		}
	},
	
	----- RED CAP -----
--[[	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR 1 501") == 0 and Return.TargetAlive("EWR 2 502") == 0 and Return.TargetAlive("EWR 3 503") == 0',
		action = {
			[1] = 'Action.TargetActive("CAP Red North", true)',
			[2] = 'Action.TargetActive("CAP Red Center", true)',
			[3] = 'Action.TargetActive("CAP Red South", true)',
			[4] = 'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		
			[5] = 'Action.TargetActive("Batumi Interception 1", false)',
			[6] = 'Action.TargetActive("Batumi Interception 2", false)',
			[7] = 'Action.TargetActive("Batumi Interception Standby 1", false)',
			[8] = 'Action.TargetActive("Sukhumi Interception 1", false)',
			[9] = 'Action.TargetActive("Sukhumi Interception 2", false)',
			[10] = 'Action.TargetActive("Sukhumi Interception Standby 1", false)',
			[11] = 'Action.TargetActive("Gudauta Interception 1", false)',
			[12] = 'Action.TargetActive("Gudauta Interception 2", false)',
			[13] = 'Action.TargetActive("Kutaisi Interception 1", false)',
			[14] = 'Action.TargetActive("Kutaisi Interception 2", false)',
			[15] = 'Action.TargetActive("Mozdok Interception 1", false)',
			[16] = 'Action.TargetActive("Mozdok Interception 2", false)',
		},
	},	--]]	
	
	----- REPAIR AND REINFORCEMENTS -----
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	-- Miguel21 modification M19 : Repair SAM
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Reinforce 98th Fighter Group"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/P51 Fighter Group", "98th Fighter Group", 6)',
	},
	["Reinforce No. 303 Squadron RAF"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/RAF", "No. 303 Squadron RAF", 6)',
	},
	["Reinforce No. 213 Squadron RAF"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/RAF", "No. 213 Squadron RAF", 4)',
	},	
	["Reinforce 368 Fighter Group"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/P-47-30", "368 Fighter Group", 4)',
	},
	["Reinforce 584th Fighter Aviation Regiment"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/I-16", "584th Fighter Aviation Regiment", 4)',
	},
	["Reinforce 34th Bombardment Group"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/Bomb Group", "34th Bombardment Group", 4)',
	},
	["Reinforce Jagdgeschwader 22"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/BF109", "Jagdgeschwader 22", 6)',
	},
	["Reinforce Jagdgeschwader 9"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/Anton", "Jagdgeschwader 9", 4)',
	},
	["Reinforce Jagdgeschwader 8"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/Anton", "Jagdgeschwader 8", 2)',
	},
	["Reinforce Jagdgeschwader 338"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/DORA", "Jagdgeschwader 338", 4)',
	},
	["Reinforce Jagdgeschwader 339"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/DORA", "Jagdgeschwader 339", 4)',
	},
	["Reinforce V./Kampfgeschwader 38"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/Junkers", "V./Kampfgeschwader 38", 4)',
	},

	----- AVIATION UNIT STATUS -----
	["368 Fighter Group Alive 75%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("368 Fighter Group") + Return.AirUnitReady("R/P-47-30") < 45',
		action = 'Action.Text("Aircraft strength of the 368 Fighter Group has fallen below 75%.")',
	},
	["368 Fighter Group Alive 50%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("368 Fighter Group") + Return.AirUnitReady("R/P-47-30") < 30',
		action = 'Action.Text("Aircraft strength of the 368 Fighter Group has fallen below 50%. If losses continue at the present rate, the combat capability of the squadron is in jeopardy.")',
	},
	["368 Fighter Group Alive 25%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("368 Fighter Group") + Return.AirUnitReady("R/P-47-30") < 15',
		action = 'Action.Text("Aircraft strength of the 368 Fighter Group has fallen below 25%. The number of available airframes is critically low. The squadron is short of destruction.")',
	},
	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
	
	
	---- NEWSPAPER ----
--[[
	["Newspaper Fulcrum"] = {
		active = true,
		once = true,
		condition = 'NoMoreNewspaper == nil and Return.Mission() > 1 and math.random(1,10) == 1',
		action = {
			[1] = 'Action.AddImage("Newspaper_Fulcrum.jpg", "blue")',
			[2] = 'NoMoreNewspaper = true',
		},
	},
	["Newspaper Gainful"] = {
		active = true,
		once = true,
		condition = 'NoMoreNewspaper == nil and Return.Mission() > 1 and math.random(1,10) == 1',
		action = {
			[1] = 'Action.AddImage("Newspaper_Gainful.jpg", "blue")',
			[2] = 'NoMoreNewspaper = true',
		},
	},
	["Newspaper Gecko"] = {
		active = true,
		once = true,
		condition = 'NoMoreNewspaper == nil and Return.Mission() > 1 and math.random(1,10) == 1',
		action = {
			[1] = 'Action.AddImage("Newspaper_Gecko.jpg", "blue")',
			[2] = 'NoMoreNewspaper = true',
		},
	}, --]]
}
